# app/models/bilan.py
from webapp import *


class BilanOuverture(db.Model):
    __tablename__="_bilan_ouverture"
    id=db.Column(db.Integer, primary_key=True)
    date_creation=db.Column(db.DateTime, default=db.func.current_timestamp())
    date=db.Column(db.DateTime, default=db.func.current_timestamp())
    objet = db.Column(db.String(255), default="")
    @property
    def date_str(self):
    	return self.date.strftime("%d/%m/%Y")

    @property
    def is_stock(self):
    	return True if self.bilan_stock else False
    @property
    def is_client(self):
    	return True if self.bilan_client else False
    @property
    def is_caisse(self):
    	return True if self.bilan_caisse else False

    @property
    def is_fournisseur(self):
    	return True if self.bilan_fournisseur else False
    @property
    def is_gerant(self):
    	return True if self.bilan_gerant else False


    @property
    def is_defined(self):
    	return self.is_stock and self.is_caisse and self.is_client and self.is_fournisseur and self.is_gerant



class BilanStock(db.Model):
	__tablename__="_bilan_stock"
	id=db.Column(db.Integer, primary_key=True)
	bilan_ouverture_id=db.Column(db.Integer, db.ForeignKey('_bilan_ouverture.id'))
	bilan_ouverture=relationship("BilanOuverture", backref='bilan_stock')
	article_id=db.Column(db.Integer, db.ForeignKey('_article.id'))
	article=relationship("Article", backref='bilan_stock')
	quantite=db.Column(db.Integer, default=0)


class BilanCaisse(db.Model):
	__tablename__="_bilan_caisse"
	id=db.Column(db.Integer, primary_key=True)
	bilan_ouverture_id=db.Column(db.Integer, db.ForeignKey('_bilan_ouverture.id'))
	bilan_ouverture=relationship("BilanOuverture", backref='bilan_caisse')
	caisse_id=db.Column(db.Integer, db.ForeignKey('_caisse.id'))
	caisse=relationship("Caisse", backref='bilan_caisse')
	solde = db.Column(db.Numeric(precision=20, scale=2), default=Decimal(0))

class BilanClient(db.Model):
	__tablename__="_bilan_client"
	id=db.Column(db.Integer, primary_key=True)
	bilan_ouverture_id=db.Column(db.Integer, db.ForeignKey('_bilan_ouverture.id'))
	bilan_ouverture=relationship("BilanOuverture", backref='bilan_client')
	client_id=db.Column(db.Integer, db.ForeignKey('_client.id'))
	client=relationship("Client", backref='bilan_client')
	credit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	debit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	@property
	def solde(self):
		return self.debit_bilan-self.credit_bilan

class BilanFournisseur(db.Model):
	__tablename__="_bilan_fournisseur"
	id=db.Column(db.Integer, primary_key=True)
	bilan_ouverture_id=db.Column(db.Integer, db.ForeignKey('_bilan_ouverture.id'))
	bilan_ouverture=relationship("BilanOuverture", backref='bilan_fournisseur')
	fournisseur_id=db.Column(db.Integer, db.ForeignKey('_fournisseur.id'))
	fournisseur=relationship("Fournisseur", backref='bilan_fournisseur')
	credit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	debit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	@property
	def solde(self):
		return self.debit_bilan-self.credit_bilan

class BilanGerant(db.Model):
	__tablename__="_bilan_gerant"
	id=db.Column(db.Integer, primary_key=True)
	bilan_ouverture_id=db.Column(db.Integer, db.ForeignKey('_bilan_ouverture.id'))
	bilan_ouverture=relationship("BilanOuverture", backref='bilan_gerant')
	gerant_id=db.Column(db.Integer, db.ForeignKey('_gerant.id'))
	gerant=relationship("Gerant", backref='bilan_gerant')
	credit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	debit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
	@property
	def solde(self):
		return self.credit_bilan-self.debit_bilan



class Inventaire(db.Model):
	__tablename__="_inventaire"
	id=db.Column(db.Integer, primary_key=True)
	date_creation=db.Column(db.DateTime, default=db.func.current_timestamp())
	date=db.Column(db.DateTime, default=db.func.current_timestamp())
	fait_par=db.Column(db.String(128),default="")
	commentaire=db.Column(db.String(256), default="")
	@property
	def date_str(self):
		return self.date.strftime("%d/%m/%Y")

class InventaireDetail(db.Model):
	__tablename__="_inventaire_detail"
	id=db.Column(db.Integer, primary_key=True)
	article_id=db.Column(db.Integer, db.ForeignKey('_article.id'))
	article=relationship("Article", backref='inventaire_detail')
	inventaire_id=db.Column(db.Integer, db.ForeignKey('_inventaire.id'))
	inventaire=relationship("Inventaire", backref='inventaire_detail')
	stock_theorique=db.Column(db.Integer, default=0)
	stock_reel=db.Column(db.Integer, default=0)


