# app/models/user.py
from webapp import *



class User(UserMixin, db.Model):
    __tablename__='_user'
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(100)) 
    phone = db.Column(db.String(100)) #telephone number
    password = db.Column(db.String(256))
    account_type = db.Column(db.String(50), default="limited") #admin, limited, super
    active = db.Column(db.Boolean, default=True)
    timelocked=db.Column(db.Boolean, default=False)
    caisse=relationship("Caisse", back_populates="user")
    def __repr__(self):
        return f'User {self.username}'
    @property
    def caisse_link(self):
        return self.caisse[0].name if self.caisse else ''

class Log(db.Model):
    __tablename__="_log"
    id=db.Column(db.Integer, primary_key=True)
    date=db.Column(db.DateTime, default=db.func.current_timestamp())
    motif=db.Column(db.String(100)) #login, logout, ajout eleve, suppression, modification
    message=db.Column(db.String(256))
    
    
# Load user callback for Flask-Login
@login_manager.user_loader
def load_user(user_id):
    return User.query.get(int(user_id))

class Gerant(db.Model):
    __tablename__="_gerant"
    id = db.Column(db.Integer, primary_key=True)
    nom=db.Column(db.String(100), default="")
    credit=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    debit=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    credit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0)) #depot
    debit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))  #retrait
    @property
    def solde(self):
        return self.solde_bilan + self.credit - self.debit
    @property
    def solde_bilan(self):
        return self.credit_bilan - self.debit_bilan
    @property
    def depot(self):
        return self.credit_bilan+self.credit
    @property
    def retrait(self):
        return self.debit_bilan+self.debit
    @classmethod
    def solde_gerant(cls):
        all_gerant=cls.query.all()
        CUMUL=Decimal(0)
        for gerant in all_gerant:
            CUMUL+=gerant.solde
        return CUMUL
 
class BalanceGerant(db.Model):
    __tablename__="_balance_gerant"
    id=db.Column(db.Integer, primary_key=True)
    date_creation = db.Column(db.Date, default=datetime.now().date())
    date = db.Column(db.Date, default=datetime.now().date())
    affectation=db.Column(db.String(100), default="")
    gerant_id = db.Column(db.Integer, db.ForeignKey('_gerant.id'))
    gerant = relationship('Gerant', backref='balance_gerant')
    credit = db.Column(db.Numeric(precision=10, scale=2), default=Decimal(0)) #depot
    debit= db.Column(db.Numeric(precision=10, scale=2), default=Decimal(0)) #retrait 
    solde=db.Column(db.Numeric(precision=10, scale=2), default=Decimal(0))
    recette_id=db.Column(db.Integer, db.ForeignKey('_recette.id'))
    recette=relationship("Recette", backref="balance_gerant")
    sortie_caisse_id=db.Column(db.Integer, db.ForeignKey('_sortie_caisse.id'))
    sortie_caisse=relationship("SortieCaisse", backref="balance_gerant")

    @property
    def ref(self):
        if self.recette_id:
            return self.recette.ref
        elif self.sortie_caisse_id:
            return self.sortie_caisse.numero_fiche
        else:
            return ""
    @property
    def date_html(self):
        return self.date.strftime("%Y-%m-%d")
    @property
    def date_str(self):
        return self.date.strftime("%d/%m/%Y")


