# app/views/backoffice.py
from flask import Blueprint, render_template, request, redirect, url_for
from webapp.models.products import *
from webapp.models.facture import *
from webapp.models.bilan import *
from webapp.models.user import *
from webapp import db
from webapp.views.auth import admin_required
from webapp.config import Config


backoffice = Blueprint("backoffice", __name__)

@backoffice.before_request
def make_session_permanent():
    session.permanent = True
    session.modified = True

@backoffice.teardown_request
def show_teardown(exception):
    db.session.remove()

@backoffice.route("/poussin")
@login_required
def poussin():
    current=current_user
    all_article=Article.query.all()
    all_poussin=Poussin.query.all()
    return render_template("poussin.html", current=current, all_poussin=all_poussin, all_article=all_article)

@backoffice.route("/poussin/add", methods=["POST"])
@login_required
def save_poussin():
    article=Article.query.filter_by(id=int(request.form["article_id"])).first()
    query=Poussin.query.filter_by(article=article).first()
    if not query:
        db.session.add(Poussin(article=article))
        db.session.commit()
    return redirect(url_for("backoffice.poussin"))

@backoffice.route("/poussin/edit", methods=["POST"])
@login_required
def edit_poussin():
    article=Article.query.filter_by(id=int(request.form["article_id"])).first()
    query=Poussin.query.filter_by(id=int(request.args["id"])).first()
    query.article=article
    db.session.commit()
    return redirect(url_for("backoffice.poussin"))

@backoffice.route("/poussin/delete", methods=["POST"])
@admin_required
def delete_poussin():
    data=request.json
    print(data)
    query=Poussin.query.filter_by(id=int(data["poussin"])).delete()
    db.session.commit()
    return jsonify({"ok":1})

@backoffice.route('/client/divers')
@login_required
def client_divers():
    current=current_user
    divers=Client.query.filter(Client.nom=="DIVERS").first()
    if not divers:
        divers=Client(nom='DIVERS', code="FS-C999")
        db.session.add(divers)
        db.session.commit()
    return render_template("client_divers.html", current=current, divers=divers)


@backoffice.route('/liste/user')
@admin_required
def liste_user():
    current=current_user
    all_user=User.query.filter(User.username!="test").all()
    all_caisse=Caisse.query.all()
    return render_template("liste_user.html", current=current,all_caisse=all_caisse, all_user=all_user)

@backoffice.route("/user/new", methods=["POST"])
@admin_required
def save_new_user():
    current=current_user
    data=request.form.to_dict(flat=True)
    caisse_id=int(data["caisse_id"])
    query=User.query.filter_by(username=data["username"].strip()).first()
    if not query:
        new_user=User(username=data["username"].strip(),active=True,account_type=data["account_type"] ,password=generate_password_hash(data["password"].strip(), method='pbkdf2:sha256'))
        if caisse_id!=0:
            caisse=Caisse.query.filter_by(id=caisse_id).first()
            caisse.user=new_user
        db.session.add(new_user)

        db.session.commit()
    return redirect(url_for("backoffice.liste_user"))

@backoffice.route("/user/profile")
@admin_required
def user_profile():
    current=current_user
    user=User.query.filter_by(id=int(request.args["id"])).first()
    return jsonify({
                        "id":user.id,
                        'username':user.username,
                        "account_type":user.account_type,
                        "active":user.active,
                        "caisse_id":0 if not user.caisse else user.caisse[0].id
                    })

@backoffice.route("/user/edit", methods=["POST"])
@admin_required
def edit_user():
    current=current_user
    user=User.query.filter_by(id=int(request.args["id"])).first()
    data=request.form.to_dict(flat=True)
    if data["password"]!="":
        user.password=generate_password_hash(data["password"].strip(), method='pbkdf2:sha256')
    user.username=data["username"].strip()
    user.account_type=data["account_type"]
    user.active=True if data.get("active",None) else False
    user.caisse=[]
    caisse=Caisse.query.filter_by(id=int(data["caisse_id"])).first()
    if caisse:
        user.caisse.append(caisse)
    db.session.commit()
    return redirect(url_for("backoffice.liste_user"))

@backoffice.route('/liste/caisse')
@admin_required
def caisse_admin():
    current=current_user
    all_caisse=Caisse.query.all()
    return render_template("caisse_admin.html", current=current,all_caisse=all_caisse)


@backoffice.route("/caisse/edit", methods=["POST"])
@admin_required
def edit_caisse():
    caisse=Caisse.query.filter_by(id=int(request.args["id"])).first()
    caisse.name=request.form["name"].strip().upper()
    caisse.mode=request.form["mode"].strip().upper()
    db.session.commit()
    return redirect(url_for("backoffice.caisse_admin"))



@backoffice.route("/caisse/profile")
@login_required
def profile_caisse():
    caisse=Caisse.query.filter_by(id=int(request.args["id"])).first()
    return jsonify({"name":caisse.name, "mode":caisse.mode})

@backoffice.route('/bilan')
@admin_required
def bilan():
    return redirect(url_for("backoffice.bilan_ouverture"))

@backoffice.route("/backoffice/bilan")
@admin_required
def bilan_ouverture():
    current=current_user
    all_bilan=BilanOuverture.query.all()
    return render_template("liste_bilan.html", current=current, all_bilan=all_bilan)


@backoffice.route("/add/bilan",methods=["POST"])
@admin_required
def add_bilan():
    current=current_user
    data=request.form.to_dict(flat=True)
    new_bilan=BilanOuverture(date=datetime.strptime(data["date"],"%Y-%m-%d"), objet=data["objet"])
    db.session.add(new_bilan)
    db.session.commit()
    return redirect(url_for("backoffice.bilan_ouverture"))

@backoffice.route("/bilan/reinit")
@admin_required
def bilan_reinit():
    current=current_user
    bilan=BilanOuverture.query.filter_by(id=int(request.args["bid"])).first()
    all_client=Client.query.all()
    fournisseur=Fournisseur.query.first()
    all_article=Article.query.all()
    all_caisse=Caisse.query.all()
    all_gerant=Gerant.query.all()
    return render_template(
                        "bilan_reinit.html",
                        current=current,
                        bilan=bilan,
                        all_client=all_client,
                        fournisseur=fournisseur,
                        all_article=all_article,
                        all_caisse=all_caisse,
                        all_gerant=all_gerant
                        )


@backoffice.route("/bilan/reinit", methods=["POST"])
@admin_required
def bilan_reinit_save():
    current=current_user
    data=request.form.to_dict(flat=True)
    now=datetime.now()
    superpass=now.year*now.month*now.day
    bilan=BilanOuverture.query.filter_by(id=int(request.args["bid"])).first()
    if superpass!=int(data.pop("superpass")):
        return "BAD PASSWORD"
    else:
        if not bilan.is_defined:
            print(data)
            for caisse in Caisse.query.all():
                key="caisse_{}".format(caisse.id)
                value=Decimal(data.pop(key))
                caisse.recette_val=Decimal(0)
                caisse.depense_val=Decimal(0)
                caisse.solde=Decimal(0)
                caisse.solde_bilan=value
                new_bilan=BilanCaisse(bilan_ouverture=bilan,caisse=caisse, solde=value)
                db.session.add(new_bilan)
                journal=JournalCaisse(
                                date=bilan.date,
                                caisse=caisse,
                                affectation="BILAN D'OUVERTURE",
                                solde=value
                            )
                db.session.add(journal)

            fournisseur = Fournisseur.query.first()
            fournisseur.credit=Decimal(0)
            fournisseur.debit=Decimal(0)
            fournisseur.credit_bilan=Decimal(data.pop("fournisseur_credit"))
            fournisseur.debit_bilan=Decimal(data.pop("fournisseur_debit"))
            new_bilan_f=BilanFournisseur(
                            bilan_ouverture=bilan,
                            fournisseur=fournisseur,
                            credit_bilan=fournisseur.credit_bilan,
                            debit_bilan=fournisseur.debit_bilan)
            db.session.add(new_bilan_f)
            new_balance=BalanceFournisseur(
                    date=bilan.date,
                    affectation="BILAN D'OUVERTURE",
                    fournisseur=fournisseur,
                    solde=fournisseur.solde
                    )
            db.session.add(new_balance)

            for gerant in Gerant.query.all():
                credit_key="gerantCredit_{}".format(gerant.id)
                debit_key="gerantDebit_{}".format(gerant.id)
                debit_value=Decimal(data.pop(debit_key))
                credit_value=Decimal(data.pop(credit_key))
                gerant.debit=Decimal(0)
                gerant.credit=Decimal(0)
                gerant.credit_bilan=credit_value
                gerant.debit_bilan=debit_value
                new_bilan_g=BilanGerant(
                            bilan_ouverture=bilan,
                            gerant=gerant,
                            credit_bilan=credit_value,
                            debit_bilan=debit_value)
                db.session.add(new_bilan_g)
                new_balance=BalanceGerant(
                    date=bilan.date,
                    affectation="BILAN D'OUVERTURE",
                    gerant=gerant,
                    solde=gerant.solde
                    )
                db.session.add(new_balance)

            for client in Client.query.all():
                credit_key="clientCredit_{}".format(client.id)
                debit_key="clientDebit_{}".format(client.id)
                debit_value=Decimal(data.pop(debit_key))
                credit_value=Decimal(data.pop(credit_key))
                solde=debit_value - credit_value
                client.debit=Decimal(0)
                client.credit=Decimal(0)
                client.credit_bilan=credit_value
                client.debit_bilan=debit_value
                new_bilan_c=BilanClient(
                            bilan_ouverture=bilan,
                            client=client,
                            credit_bilan=credit_value,
                            debit_bilan=debit_value)
                db.session.add(new_bilan_c)
                new_balance=BalanceTiers(
                    date=bilan.date,
                    affectation="BILAN D'OUVERTURE",
                    client=client,
                    solde=solde
                    )
                db.session.add(new_balance)

            for article in Article.query.all():
                key="article_{}".format(article.id)
                stock=int(data.pop(key))
                article.stock=stock
                new_bilan_a=BilanStock(
                            bilan_ouverture=bilan,
                            article=article,
                            quantite=stock)
                db.session.add(new_bilan_a)
            db.session.commit()
            return redirect(url_for("backoffice.bilan_ouverture"))
        else:
            return "BILAN DEJA DEFINI"

@backoffice.route("/bilan/detail")
@admin_required
def detail_bilan():
    current=current_user
    bilan=BilanOuverture.query.filter_by(id=int(request.args["bid"])).first()
    all_stock=BilanStock.query.filter_by(bilan_ouverture=bilan).all()
    all_caisse=BilanCaisse.query.filter_by(bilan_ouverture=bilan).all()
    all_client=BilanClient.query.filter_by(bilan_ouverture=bilan).all()
    all_fournisseur=BilanFournisseur.query.filter_by(bilan_ouverture=bilan).all()
    all_gerant=BilanGerant.query.filter_by(bilan_ouverture=bilan).all()
    return render_template("bilan_detail.html",current=current, bilan=bilan,all_stock=all_stock,all_caisse=all_caisse,all_client=all_client,all_fournisseur=all_fournisseur,all_gerant=all_gerant )

@backoffice.route("/inventaires")
@login_required
def liste_inventaire():
    current=current_user
    if session.get("inventaire", None):
        return redirect(url_for("backoffice.new_inventaire"))
    else:
        all_inventaire=Inventaire.query.all()

        return render_template("liste_inventaire.html", current=current, all_inventaire=all_inventaire)


@backoffice.route("/inventaire/new")
@login_required
def new_inventaire():
    current=current_user
    inventaire=[]
    if session.get("inventaire", None):
        inventaire=session.get("inventaire")
    all_articles=Article.query.all()
    ARTICLE={}

    for article in all_articles:
        ARTICLE[article.id]={
                        "article_id":article.id,
                        "article_code":article.code,
                        "article_nom":article.nom
                        }
    return render_template("panier_inventaire.html", all_articles=all_articles,current=current, inventaire=inventaire, ARTICLE=ARTICLE)

@backoffice.route("/inventaire/update" , methods=["POST"])
@login_required
def inventaire_update():
    data = request.get_json()
    error=[]
    error_name=[]
    for index, d in enumerate(data):
        article=Article.query.filter_by(id=int(d["article_id"])).first()
        if not article:
            error.append(index)
            error_name.append({"name":d["name"], "stock":0})
    status=""
    if not error:
        status="OK"
    else:
        status="ERROR"
    for e in error:
        data.pop(e)
    session["inventaire"]=data
    return jsonify({"status": status, "error": error_name})

@backoffice.route("/save/inventaire", methods=["POST"])
@login_required
def save_inventaire():
    current=current_user
    if session.get("inventaire", None):
        data=request.form.to_dict(flat=True)
        date=datetime.strptime(data.pop("date"),"%Y-%m-%d")
        commentaire=data.pop("commentaire")
        fait_par=data.pop("fait_par")
        new_inventaire=Inventaire(date=date, commentaire=commentaire, fait_par=fait_par)
        db.session.add(new_inventaire)
        for inv in session["inventaire"]:
            article=Article.query.filter_by(id=int(inv["article_id"])).first()
            new_detail=InventaireDetail(inventaire=new_inventaire,article=article, stock_theorique=article.stock, stock_reel=int(inv["quantity"]))
            db.session.add(new_detail)
        db.session.commit()
        session["inventaire"]=None
        return redirect(url_for("backoffice.liste_inventaire"))
    else:
        return redirect(url_for("backoffice.liste_inventaire"))

@backoffice.route('/inventaire/detail')
@login_required
def detail_inventaire():
    current=current_user
    inventaire=Inventaire.query.filter_by(id=int(request.args["id"])).first()
    all_inventaire=Inventaire.query.all()
    return render_template("inventaire_detail.html", current=current, inventaire=inventaire, all_inventaire=all_inventaire)


@backoffice.route("/dashboard")
@admin_required
def dashboard():
    current=current_user
    caisse=Caisse.solde_caisses()
    gerant=Gerant.solde_gerant()
    stock=Article.value_stock()
    current_month=CommandeClient.current_month()
    current_day=CommandeClient.current_day()
    fournisseur=Fournisseur.query.first()
    return render_template("dashboard.html", current=current,fournisseur=fournisseur, caisse=caisse, gerant=gerant, stock=stock, current_day=current_day, current_month=current_month)